IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_PROD_COND_CP_PG_FORN_VIGENTE]') 
					AND TYPE IN (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_EST_PROD_COND_CP_PG_FORN_VIGENTE]
	END
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Calcula valor de referencia para garantir melhor condição de compra 
'Tabelas.............: 
'Dt Modificação......: 16/02/2021
'Modificação.........: Tag #A001 Alteração no nome da flag NAO_APLICAR_TRIBUTACAO_MCC para APLICAR_TRIBUTACAO_MCC 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
GO
--EXEC P_EST_PROD_COND_CP_PG_FORN_VIGENTE
CREATE PROCEDURE [DBO].[P_EST_PROD_COND_CP_PG_FORN_VIGENTE]
WITH ENCRYPTION 
AS
BEGIN TRY
BEGIN  
	SET NOCOUNT ON;
	/*********************************/

	--STATUS DAS CONDICOES - ST_COND_CP 
	-- 0 - PENDENTE
	-- 1 - ATIVA
	-- 2 - VENCIDA
	-- 3 - INVÁLIDA (CORTE PARAMETRO)
	/*********************************/
	 
	DECLARE @CD_ORDEM		INT
	DECLARE @CD_PROD_ANT	INT
	DECLARE @PERC_JUR_DIA   NUMERIC(35,10)
	DECLARE @VLR_REF		NUMERIC(35,10)
	DECLARE @TP_PRC_AUDIT   INT
	DECLARE @TP_PRC_IMPORTADO  TINYINT;
	
	DECLARE @CD_EMP_RS		INT
	DECLARE @CD_PROD_RS		INT
	DECLARE @CD_FORN_RS		INT
	DECLARE @VLR_CUSTO_RS	MONEY
	DECLARE @PERC_DESC_RS	MONEY
	DECLARE @DT_INI_VLD_RS	DATETIME
	DECLARE @DT_FIM_VLD_RS	DATETIME				
	DECLARE @CD_BASE_PRECO  INT
	DECLARE @NaoAplicaTrib	TINYINT,@NaoValidarMargemMCC TINYINT;
	 

	CREATE TABLE #RsFornProc (CD_EMP INT,
							  CD_FORN INT,
							  DT_PROC DATETIME,
							  DT_PROC_INI DATETIME)


	INSERT INTO #RsFornProc (CD_EMP, CD_FORN, DT_PROC, DT_PROC_INI)
	SELECT
		CD_EMP,
		CD_FORN,
		DT_PROC,
		GETDATE()
	FROM
		PG_FORN_PROC_MCC
	WHERE
		DT_PROC = CONVERT(DATE,GETDATE()) 
		AND STS_PROC=0
		AND PROC_LIB_USU=0
	
-- Tag #A001
	SET @NaoAplicaTrib=ISNULL((SELECT VALOR FROM prc_emp_config WHERE
							 cd_chave='APLICAR_TRIBUTACAO_MCC'),0);
	
	set @NaoValidarMargemMCC =ISNULL((SELECT VALOR FROM prc_emp_config WHERE
							 cd_chave='NAO_VALIDAR_MARGEM_MCC'),0);
					
	SET @CD_BASE_PRECO = (SELECT TOP 1 CD_FILIAL FROM PRC_FILIAL WHERE FILIAL_MTZ=1);
	PRINT 'Time - 41' + convert(varchar, getdate(), 108)
	CREATE TABLE #TBL_PEND_ANALISE (CD_EMP     INT,
										CD_PROD    INT,
										CD_FORN    INT,
										VLR_CUSTO  MONEY,
										PERC_DESC  MONEY,
										DT_INI_VLD DATETIME,
										DT_FIM_VLD DATETIME,
										QT_EST	   MONEY);	
	IF EXISTS (SELECT 1 FROM #TBL_PEND_ANALISE )
	TRUNCATE TABLE #TBL_PEND_ANALISE
	CREATE TABLE #TBL_PROD_EMPATE (   CD_EMP     INT,
										CD_PROD    INT,										
										VLR_REF    MONEY);
	
 
	CREATE TABLE #TBL_PROD_DESEMPATE( CD_CTR     INT,
										CD_EMP     INT,	
										CD_PROD    INT,										
										CD_FORN    INT,
										CD_ORDEM   INT,
										VLR_REF    MONEY )
	IF EXISTS (SELECT 1 FROM #TBL_PROD_DESEMPATE )
	TRUNCATE TABLE #TBL_PROD_DESEMPATE
	CREATE CLUSTERED INDEX IX_TBL_PROD_DESEMPATE ON #TBL_PROD_DESEMPATE (CD_EMP,CD_PROD,VLR_REF,CD_ORDEM)
	 
	
	SET @PERC_JUR_DIA = ISNULL((SELECT PERC_JUR_DIA FROM EST_COND_CP_CONFIG WHERE CD_EMP = 1),0) / 100
	SET @TP_PRC_AUDIT = ISNULL((SELECT TP_PRC_AUDIT FROM EST_COND_CP_CONFIG WHERE CD_EMP = 1),0)
	SET @TP_PRC_IMPORTADO = ISNULL((SELECT TP_PRC_IMP FROM EST_COND_CP_CONFIG WHERE CD_EMP = 1),0) -- TP_PRC_IMP = 1 Liquido (nao considera descontos.)


	PRINT 'Time - ' + convert(varchar, getdate(), 108)
	PRINT 'PROCESSANDO CONDICOES DO DIA ' + CONVERT(VARCHAR,convert(Date,getdate() ),112);
	--------------------------------------------------------------------------------------------------------------------------
	--IMPLEMENTANDO AS CONDICOES FIXAS
	--------------------------------------------------------------------------------------------------------------------------
 
	--EXCLUI TODAS AS CONDICOES FIXAS 
   
	DELETE FROM 
		EST_PROD_COND_CP_PG_FORN
	WHERE 
	   CD_EMP=1 
	   AND TP_COND_CP=1;
	
	PRINT 'Inserindo condicoes de compra fixas'
	PRINT 'Time - ' + convert(varchar, getdate(), 108)
	INSERT INTO EST_PROD_COND_CP_PG_FORN (CD_EMP,CD_PROD,CD_FORN,CD_ORDEM,VLR_CUSTO,
										  ST_COND_CP,DT_INI_VLD,DT_FIM_VLD,PERC_DESC,TP_COND_CP, QT_EST)
	SELECT 
		C.CD_EMP,
		P.CD_PROD,
		C.CD_FORN,
		C.CD_ORDEM,
		ISNULL(T.VLR_FORN,P.VLR_COMPRA_GRP) VLR_CUSTO,
		1 ST_COND_CP, -- JA GRAVA COMO PROCESSADA
		CONVERT(DATE,GETDATE())   DT_INI_VLD,
		CONVERT(DATE,GETDATE() + 1) DT_FIM_VLD,
		case when @TP_PRC_IMPORTADO = 1 then 0 else C.PERC_DESC end PERC_DESC,
		1 TP_COND_CP, -- TIPO CONDICAO COMPRA  0 NORMAL (IMPORTACAO) - 1 FIXO (TABELA EST_PROD_FABRIC_PG_FORN)
		0 AS QT_EST
	FROM  
		EST_PROD_FABRIC_PG_FORN C
		INNER JOIN EST_PROD P ON 
		C.CD_EMP = P.CD_EMP AND
		C.CD_FABRIC = P.CD_FABRIC
		LEFT  JOIN EST_PROD_PRECO_TBL T ON 
		P.CD_EMP = T.CD_EMP AND
		P.CD_PROD= T.CD_PROD
		AND T.CD_CTR_GRP=1
		
		LEFT JOIN EST_PROD_COND_CP_PG_FORN CV ON 
		C.CD_EMP = CV.CD_EMP AND
		C.CD_FORN = CV.CD_FORN AND
		P.CD_PROD = CV.CD_PROD 
	WHERE P.STS_PROD=0	AND CV.CD_EMP IS NULL;
		
	PRINT 'Time - 120 ' + convert(varchar, getdate(), 108)		  
	--INSERE AS NOVAS
	INSERT INTO EST_PROD_COND_CP_PG_FORN_VIGENTE(CD_EMP,CD_PROD,CD_FORN,CD_ORDEM,VLR_CUSTO,
														ST_COND_CP,DT_INI_VLD,DT_FIM_VLD,PERC_DESC,
														VLR_REF,TP_PRC_AUDIT,TP_COND_CP, QT_EST)
	SELECT 
		C.CD_EMP,
		P.CD_PROD,
		C.CD_FORN,
		C.CD_ORDEM,
		ISNULL(T.VLR_FORN,P.VLR_COMPRA_GRP) VLR_CUSTO,
		1 ST_COND_CP, -- JA GRAVA COMO PROCESSADA
		CONVERT(DATE,GETDATE())   DT_INI_VLD,
		CONVERT(DATE,GETDATE() + 1) DT_FIM_VLD,
		case when @TP_PRC_IMPORTADO = 1 then 0 else C.PERC_DESC end PERC_DESC,
		0 VLR_REF,
		0 TP_PRC_AUDIT,
		1 TP_COND_CP, -- TIPO CONDICAO COMPRA  0 NORMAL (IMPORTACAO) - 1 FIXO (TABELA EST_PROD_FABRIC_PG_FORN)
		CV.QT_EST
	FROM  
		EST_PROD_FABRIC_PG_FORN C
		INNER JOIN EST_PROD P ON 
		C.CD_EMP = P.CD_EMP AND
		C.CD_FABRIC = P.CD_FABRIC
		LEFT  JOIN EST_PROD_PRECO_TBL T ON 
		P.CD_EMP = T.CD_EMP AND
		P.CD_PROD= T.CD_PROD
		AND T.CD_CTR_GRP=1 

		INNER JOIN EST_PROD_COND_CP_PG_FORN CV ON 
		C.CD_EMP = CV.CD_EMP AND
		C.CD_FORN = CV.CD_FORN AND
		P.CD_PROD = CV.CD_PROD
		AND CV.TP_COND_CP=1
		 		
	WHERE P.STS_PROD=0 
	   AND P.CD_EMP=1;
		
	--------------------------------------------------------------------------------------------------------------------------
	--DELETANDO VALORES COM CUSTO ZERADO
	--------------------------------------------------------------------------------------------------------------------------
	PRINT 'Time - 160 ' + convert(varchar, getdate(), 108)
	DELETE FROM EST_PROD_COND_CP_PG_FORN WHERE VLR_CUSTO = 0;
		 
	--------------------------------------------------------------------------------------------------------------------------
	--EXPIRANDO AS CONDIÇÕES DE COMPRA JÁ VENCIDAS PELA DATA FINAL
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE EST_PROD_COND_CP_PG_FORN_VIGENTE SET
			ST_COND_CP = 2
	WHERE DT_FIM_VLD < convert(Date,getdate() ) 
		AND NOT ST_COND_CP IN (2,3)	
		 
	--------------------------------------------------------------------------------------------------------------------------
	--OBTENDO AS IMPORTAÇÕES PENDENTE DE ANALISE
	--------------------------------------------------------------------------------------------------------------------------
	INSERT INTO 
		#TBL_PEND_ANALISE
	SELECT  
		CD_EMP,
		CD_PROD,
		CD_FORN,
		VLR_CUSTO,
		PERC_DESC,
		(CASE WHEN DT_INI_VLD < convert(Date,getdate() ) 
			THEN convert(Date,getdate() ) 
			ELSE DT_INI_VLD END) AS DT_INI_VLD,
		DT_FIM_VLD,
		QT_EST
	FROM 
		EST_PROD_COND_CP_PG_FORN  
	WHERE 
		ST_COND_CP = 1
		AND ISNULL(TP_COND_CP,0)<>1
		AND DT_FIM_VLD>=convert(Date,getdate() ) ;

		
    CREATE CLUSTERED INDEX IX_#TBL_PEND_ANALISE ON #TBL_PEND_ANALISE (CD_EMP,CD_PROD,CD_FORN, DT_INI_VLD)

    PRINT 'Time - 194 ' + convert(varchar, getdate(), 108)
	--------------------------------------------------------------------------------------------------------------------------
	--ALTERANDO O STATUS DE PENDÊNCIA DE ANALISE DA CONDIÇÃO DE COMPRA
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE 
		EST_PROD_COND_CP_PG_FORN 
	SET
		ST_COND_CP = 0
	WHERE 
		ST_COND_CP = 1	
		AND ISNULL(TP_COND_CP,0)<>1 
	
	--------------------------------------------------------------------------------------------------------------------------
	--ALTERANDO A DATA DE VALIDADE DOS CONFLITOS DE DATA DE VENCIMENTO DA CONDIÇÃO POR FORNECEDOR
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE 
		V 
	SET	
		DT_FIM_VLD = DATEADD(DAY, -1, A.DT_INI_VLD)
	FROM 
		EST_PROD_COND_CP_PG_FORN_VIGENTE V 
		INNER JOIN #TBL_PEND_ANALISE A ON
			V.CD_EMP      = A.CD_EMP
			AND V.CD_PROD = A.CD_PROD
			AND V.CD_FORN = A.CD_FORN		
	WHERE 
		V.DT_FIM_VLD >= A.DT_INI_VLD 
		AND V.DT_FIM_VLD >=CONVERT(DATE,GETDATE())
		AND not V.TP_COND_CP = 1
		AND a.CD_EMP=1;

	--------------------------------------------------------------------------------------------------------------------------
	--GRAVANDO OS REGISTROS IMPORTADOS PARA REALIZAR A ANALISE 
	--------------------------------------------------------------------------------------------------------------------------
 
		INSERT INTO EST_PROD_COND_CP_PG_FORN_VIGENTE 
					(CD_EMP, CD_PROD, CD_FORN, CD_ORDEM, ST_COND_CP, VLR_CUSTO, PERC_DESC, 
						DT_INI_VLD, DT_FIM_VLD, TP_PRC_AUDIT,TP_COND_CP,TP_INVALIDO, QT_EST)				
		SELECT  
			CD_EMP,
			CD_PROD,
			CD_FORN,
			99 CD_ORDEM,
			0 ST_COND_CP,
			VLR_CUSTO,
			PERC_DESC,				
			DT_INI_VLD,
			DT_FIM_VLD,
			@TP_PRC_AUDIT,
			0 TP_COND_CP,
			0 TP_INVALIDO,
			QT_EST
		FROM 
			#TBL_PEND_ANALISE 
		where
			DT_FIM_VLD >= convert(Date,getdate() );
				 
	 PRINT 'Time - 236 ' + convert(varchar, getdate(), 108)
	--------------------------------------------------------------------------------------------------------------------------
	--GARANTINDO QUE NÃO PERMANECERÁ LIXO CASO SEJA RE-PROCESSO ESTA ROTINA NO MESMO DIA.
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE 
		EST_PROD_COND_CP_PG_FORN_VIGENTE 
	SET 
		ST_COND_CP = 2
	WHERE 
		DT_FIM_VLD < DT_INI_VLD   
		AND ST_COND_CP <>2
		AND CD_EMP=1
	--------------------------------------------------------------------------------------------------------------------------
	--COLOCANDO A CONDIÇÃO DE COMPRA EM VIGENCIA
	--------------------------------------------------------------------------------------------------------------------------
	
	PRINT 'Time - 249 ' + convert(varchar, getdate(), 108)
	UPDATE 
		EST_PROD_COND_CP_PG_FORN_VIGENTE 
	SET 
		ST_COND_CP = 1
	WHERE 
		convert(Date,getdate() ) 
		BETWEEN DT_INI_VLD AND DT_FIM_VLD
		AND CD_EMP=1
		AND ST_COND_CP <> 1 ;
    --------------------------------------------------------------------------------------------------------------------------
	--ELIMINA PRODUTO INATIVO NO FORNECEDOR
	UPDATE 
		A 
	SET 
		ST_COND_CP=3,
		TP_INVALIDO=3,
		DS_TP_INVALIDO='PRODUTO INATIVO NO FORNECEDOR (DICIONARIO)'
	from 
		EST_PROD_COND_CP_PG_FORN_VIGENTE A
		LEFT JOIN EST_PROD_FORN B ON 
			A.CD_EMP	 = B.CD_EMP AND
			A.CD_PROD	 = B.CD_PROD AND
			A.CD_FORN	 = B.CD_FORN 
	WHERE
		ISNULL(B.COMPRA_INATIVA,1)=1 
		AND A.CD_EMP=1
		AND A.ST_COND_CP=1;

    --------------------------------------------------------------------------------------------------------------------------
    --CALCULANDO O PREÇO DE REFERÊNCIA COM BASE NA TAXA DE JUROS DO CAPITAL
    --------------------------------------------------------------------------------------------------------------------------		
	  
	 /*
	   DECLARE @MOV_COMPRA		INT	   
	   SET @MOV_COMPRA= ISNULL((select MIN(CD_MOV_OP) from    glb_mov_op
				    where   
					   tp_mov_op_transa=0
					   and tp_mov=0
					   and sts_mov =0 
					   and atu_est=1
					   and dest_orig=1),0);
					   */
		PRINT 'Time - 272 ' + convert(varchar, getdate(), 108)
		UPDATE 
			V 
		SET  
			@VLR_REF = 0,
			@VLR_REF = (V.VLR_CUSTO - ((V.VLR_CUSTO * V.PERC_DESC) / 100)),			
			@VLR_REF = @VLR_REF - (@VLR_REF * CAST(POWER ((@PERC_JUR_DIA + 1), ISNULL(PG_FORN.PRZ_COMPRA,0)) - 1 AS NUMERIC(15,6))),
			VLR_REF = @VLR_REF
	   FROM 
			EST_PROD_COND_CP_PG_FORN_VIGENTE V 
			INNER JOIN PG_FORN ON
				V.CD_EMP		= PG_FORN.CD_EMP
				AND V.CD_FORN	= PG_FORN.CD_FORN			
	   WHERE 
			V.ST_COND_CP IN (0,1);
	   
	   PRINT 'Time - 285 ' + convert(varchar, getdate(), 108)
	   --Aplicando a tributacao
	   if @NaoAplicaTrib =0
	   begin
		  UPDATE 
				V
		  SET
			-- VLR_CUSTO = u.VLR_CUSTO,
			 VLR_REF  = u.VLR_CUSTO 
		  FROM 
			 EST_PROD_COND_CP_PG_FORN_VIGENTE V 
			 cross apply dbo.UFD_EST_PROD_TRIB(1
										  ,@CD_BASE_PRECO --@CD_FILIAL
										  ,0 --@CD_MOV_OP
										  ,v.CD_FORN
										  ,v.CD_PROD
										  ,0 --@GERA_DARE
										  ,0 --@TP_MOV
										  ,0 --@TP_MOV_OP_TRANSA
										  ,1 --@QT_PROD
										  ,V.VLR_REF --@VLR_IT
										  ,0--@PERC_DESC_IT
										  ,0--@PERC_IPI
										  ,0--@VLR_FRETE
										  ,0--@VLR_OUTRAS
										  ,0--TipoTransacao
										  ,0--IcmsEntrada
										  ) U
		  WHERE V.ST_COND_CP IN (0,1);
	   end
	   PRINT 'Time - 312 ' + convert(varchar, getdate(), 108)
	   --aplicando o desconto financeiro...
	   UPDATE V
	   SET
		  VLR_REF = v.VLR_REF-(v.VLR_REF*( COALESCE (F.PERC_DESC_FINAN,FF.PERC_COMIS_VEND, 0) /100.0000))
	   FROM 
		  EST_PROD_COND_CP_PG_FORN_VIGENTE  V
		  LEFT JOIN EST_PROD_DESC_FINAN F ON		  
			  V.CD_EMP		= F.CD_EMP
			  AND V.CD_FORN	= F.CD_FORN			
			  AND V.CD_PROD     = F.CD_PROD
		  JOIN PG_FORN FF ON		  
			  V.CD_EMP		= FF.CD_EMP
			  AND V.CD_FORN	= FF.CD_FORN			
	   WHERE 
		  V.ST_COND_CP IN (0,1);

	--------------------------------------------------------------------------------------------------------------------------
	--VERIFICANDO OS PRODUTOS QUE HOUVERAM EMPATE DE PREÇO
	--------------------------------------------------------------------------------------------------------------------------
	INSERT INTO 
		#TBL_PROD_EMPATE
	SELECT 
		CD_EMP, 
		CD_PROD, 
		VLR_REF
	FROM 
		EST_PROD_COND_CP_PG_FORN_VIGENTE
	WHERE 
		ST_COND_CP = 1		
		--AND ISNULL(TP_COND_CP,0)<>1 
	GROUP BY 
		CD_EMP, 
		CD_PROD, 
		VLR_REF
	HAVING COUNT(1) > 1 ;
	 
	--------------------------------------------------------------------------------------------------------------------------
	--PRÉ ORDENANDO OS PRODUTOS E VERIFICANDO A ORDEM DE DESEMPATE PARA OS PRODUTOS QUE HOUVERAM EMPATE NO PREÇO
	--------------------------------------------------------------------------------------------------------------------------
	INSERT INTO 
		#TBL_PROD_DESEMPATE
	SELECT 
		V.CD_CTR, 
		V.CD_EMP, 
		V.CD_PROD, 
		V.CD_FORN, 
		ISNULL( F.CD_ORDEM,99) ORDENACAO, 
		V.VLR_REF
	FROM 
		EST_PROD_COND_CP_PG_FORN_VIGENTE V 
		INNER JOIN EST_PROD P ON
			V.CD_EMP		= P.CD_EMP
			AND V.CD_PROD	= P.CD_PROD
		LEFT JOIN EST_PROD_FABRIC_COND_CP_PG_FORN F ON
			V.CD_EMP		= F.CD_EMP
			AND V.CD_FORN	= F.CD_FORN
			AND P.CD_FABRIC = F.CD_FABRIC
		LEFT JOIN #TBL_PROD_EMPATE PE ON
			V.CD_EMP		= PE.CD_EMP
			AND V.CD_PROD	= PE.CD_PROD
			AND V.VLR_REF	= PE.VLR_REF
	WHERE V.ST_COND_CP = 1
		--AND ISNULL(TP_COND_CP,0)<>1 
	ORDER BY V.CD_EMP, V.CD_PROD, V.VLR_REF, ORDENACAO ;
	  
	SET @CD_PROD_ANT = 0;
	SET @CD_ORDEM = 0;
	PRINT 'Time - 365 ' + convert(varchar, getdate(), 108)
	--------------------------------------------------------------------------------------------------------------------------
	--ESTABELECENDO A ORDEM DA MELHOR CONDIÇÃO DE COMPRA
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE D SET 
		@CD_ORDEM = (CASE WHEN @CD_PROD_ANT = D.CD_PROD THEN @CD_ORDEM ELSE 0 END),
		CD_ORDEM = @CD_ORDEM,			
		@CD_ORDEM = @CD_ORDEM + 1,
		@CD_PROD_ANT = D.CD_PROD			
	FROM #TBL_PROD_DESEMPATE D 
	; 
	--------------------------------------------------------------------------------------------------------------------------
	--APLICANDO A ORDEM DE MELHOR CONDIÇÃO A TABELA DO SISTEMA
	--------------------------------------------------------------------------------------------------------------------------
	UPDATE 
		V 
	SET 			
		CD_ORDEM = D.CD_ORDEM
	FROM 
		EST_PROD_COND_CP_PG_FORN_VIGENTE V 
		INNER JOIN #TBL_PROD_DESEMPATE D ON
			V.CD_CTR = D.CD_CTR;

	--------------------------------------------------------------------------------------------------------------------------
	--APLICANDO FILTRO DE CORTE DE CONDIÇÃO
	--   PARA GARANTIR APENAS BOA CONDIÇOES DEFINIDAS POR MARGEM E LINHA
	--   ALTERA AS MÁS CONDICOES PARA STATUS = 3 -->INVALIDA
	--------------------------------------------------------------------------------------------------------------------------
	PRINT 'Time - 390 ' + convert(varchar, getdate(), 108)


	--ELIMINA VLR MAIOR Q PRECO VENDA 
	UPDATE 
		A 
	SET 
		ST_COND_CP=3,   
		TP_INVALIDO=1, 
		DS_TP_INVALIDO='VALOR MAIOR QUE O PRECO DE VENDAS'
	FROM
		EST_PROD_COND_CP_PG_FORN_VIGENTE A 
		INNER JOIN EST_PROD_PRECO D ON
			A.CD_EMP	= D.CD_EMP AND
			A.CD_PROD	= D.CD_PROD
			AND D.CD_FILIAL = @CD_BASE_PRECO 
			AND case when d.VLR_OFERTA> 0 THEN  d.VLR_OFERTA ELSE D.VLR_TABELA END > 0 
	WHERE
		A.ST_COND_CP=1
		AND A.VLR_REF> case when d.VLR_OFERTA> 0 THEN  d.VLR_OFERTA
			ELSE D.VLR_TABELA END
		AND D.VLR_TABELA>0;
	   

     --------------------------------------------------------------------------------------------------------------------------

	--ELIMINA VLR MAIOR Q PRECO VENDA
	if @NaoValidarMargemMCC = 0
	begin
	
		UPDATE 
			A 
		SET 
			ST_COND_CP=3,   
			TP_INVALIDO=2, DS_TP_INVALIDO='VALOR MAIOR QUE O PRECO DE VENDAS'
		FROM
			EST_PROD_COND_CP_PG_FORN_VIGENTE A
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA B ON
				A.CD_EMP	= B.CD_EMP AND
				A.CD_PROD	= B.CD_PROD
			INNER JOIN  EST_COND_CP_CONFIG_MARGEM_EST_ARV_MERC_LINHA  C ON
				B.CD_EMP			= C.CD_EMP AND
				B.CD_ARV_MERC_LINHA	= C.CD_ARV_MERC_LINHA
				AND C.PERC_MARGEM>0
			INNER JOIN EST_PROD_PRECO D ON
				A.CD_EMP	= D.CD_EMP AND
				A.CD_PROD	= D.CD_PROD
				AND D.CD_FILIAL = @CD_BASE_PRECO 
				AND  case when d.VLR_OFERTA> 0 THEN  d.VLR_OFERTA ELSE D.VLR_TABELA END > 0
		WHERE
			ST_COND_CP=1
			AND ((1-(VLR_REF/(case when d.VLR_OFERTA> 0 THEN  d.VLR_OFERTA
								ELSE D.VLR_TABELA END)))*100.000) < C.PERC_MARGEM
	end

	PRINT 'Time - 435 ' + convert(varchar, getdate(), 108)
	--------------------------------------------------------------------------------------------------------------------------
	--FIM
	--------------------------------------------------------------------------------------------------------------------------
	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_DESEMPATE') IS NOT NULL
	BEGIN
		DROP TABLE #TBL_PROD_DESEMPATE
	END 
	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PEND_ANALISE') IS NOT NULL
	BEGIN
		DROP TABLE #TBL_PEND_ANALISE
	END
	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_EMPATE') IS NOT NULL
	BEGIN
		DROP TABLE #TBL_PROD_EMPATE
	END

	UPDATE
		MCC
	SET
		STS_PROC=1,
		DT_PROC_MCC_INI=PEN.DT_PROC_INI,
		DT_PROC_MCC_FIM=GETDATE()
	FROM
		PG_FORN_PROC_MCC MCC INNER JOIN  #RsFornProc pen ON
		MCC.CD_EMP = pen.CD_EMP AND
		MCC.CD_FORN = pen.CD_FORN AND
		MCC.DT_PROC = pen.DT_PROC

	DROP TABLE #RsFornProc

END
END TRY

BEGIN CATCH
	BEGIN TRY
		CLOSE RS_PROD_ANALISE
		DEALLOCATE RS_PROD_ANALISE	
	END TRY
	BEGIN CATCH END CATCH;
	
	INSERT INTO ADM_ERRO (NUMERO, SEVERIDADE, ESTADO, ROTINA, LINHA, MENSAGEM, DTERRO)
		SELECT
			ERROR_NUMBER() AS NUMERO,
			ERROR_SEVERITY() AS SEVERIDADE,
			ERROR_STATE() AS ESTADO,
			ERROR_PROCEDURE() AS ROTINA,
			ERROR_LINE() AS LINHA,
			ERROR_MESSAGE() AS MENSAGEM,
			GETDATE() AS DTERRO;	
END CATCH
 


